PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144440341"
 Author = "jayas.jayas"
 Desc = "Single Transmission Line"
 Arch = "windows"
 Options = 0
 Build = 18
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 391
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Controls")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [2]
    }
   Output("F",36,18)
    {
    Type = Integer
    }
   Input("FType",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   Pen(Black)
   Line(27,-18,36,-18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Sticky-([72,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,198,216,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(23435208)
    Dial(63439696)
    Slider(23238024)
    Slider(23237016)
    Slider(23515944)
    }
   -Wire-([1224,828],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datamerge([1422,1062],4,0,180)
    {
    N = "2"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1404,990],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1404,1008],6,0,-1)
    {
    Name = "B2"
    }
   0.export([1458,1098],4,0,170)
    {
    Name = "F"
    }
   0.datalabel([1098,648],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1098,702],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1098,756],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1062,648],0,22745496,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.31"
    Units = "s"
    Collect = "1"
    }
   0.var([1062,702],0,22746656,40)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.36"
    Units = "s"
    Collect = "1"
    }
   0.var([1062,756],0,22748352,60)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.33"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([1026,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 1026,198,1170,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Wire-([1224,648],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([1098,810],3,0,-1)
    {
    Name = "B2T2"
    }
   0.tbreakn([1170,648],4,0,110)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   -ControlPanel-([1026,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1026,252
    Extents = 0,0,216,126
    Switch(22847912)
    Slider(22745496)
    Slider(22746656)
    }
   -Wire-([666,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([702,720],0,0,-1)
    {
    Name = "Tfs"
    }
   -Wire-([666,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([702,792],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([828,756],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1368,1098],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1368,1098],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.var([1062,810],0,21847304,80)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.4"
    Units = "s"
    Collect = "1"
    }
   -ControlPanel-([1026,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1026,396
    Extents = 0,0,216,126
    Switch(22849144)
    Slider(22748352)
    Slider(21847304)
    }
   0.tbreakn([1170,828],4,0,90)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1224,684],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1260,828],6,0,150)
    {
    Type = "1"
    Inv = "0"
    }
   0.datalabel([1188,738],0,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1188,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.import([1458,1152],0,0,100)
    {
    Name = "FType"
    }
   0.logic([1260,648],0,0,120)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1296,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1296,612],0,22847912,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([1404,648],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1296,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Sticky-([1044,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1044,954,1170,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([1026,594],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1026,594,1206,630
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.var_switch([1296,774],6,22849144,70)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1332,792],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([1404,792],2,0,-1)
    {
    Name = "B2"
    }
   0.logic([1368,792],0,0,160)
    {
    Type = "2"
    Inv = "0"
    }
   0.logic([1368,648],6,0,130)
    {
    Type = "2"
    Inv = "0"
    }
   0.export([1458,1044],4,0,190)
    {
    Name = "B"
    }
   0.tfaultn([792,756],4,0,140)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([486,144],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 486,144,666,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.arrow_a([522,180],1,0,-1)
    {
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(23508032)
    Meter(46662440)
    Meter(46664024)
    Slider(23508704)
    Meter(23403512)
    Meter(23230232)
    Meter(23231592)
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,504,126
    Slider(23509104)
    Meter(25577000)
    Meter(25578720)
    Slider(39909608)
    Meter(39908112)
    Meter(23480288)
    Meter(25575552)
    }
   0.var([630,792],0,23237016,50)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.12"
    Units = ""
    Collect = "1"
    }
   0.var([630,720],0,23238024,30)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([180,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,900,288,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> BC 
11=> No fault (0)"
    }
   -Sticky-([36,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 36,900,162,1098
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source 
          and B1
  2=> FT2:
          Between Line 
          and B1
  3=> FT3:
          Between Line 
          and B2
  4=> FT4:
          Between Source
          and B2"
    }
   -Sticky-([738,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 738,468,918,594
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, 
click on the switch.
On = Recorder will record data.
Off = Recorder will NOT
          record data.

You can turn on or off 
each recorder individually."
    }
   -ControlPanel-([756,324],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Switch(63058752)
    Switch(39914720)
    }
   -ControlPanel-([756,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(39911976)
    Slider(23401472)
    }
   -Sticky-([756,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 756,126,882,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   -Divider-([36,630],0)
    {
    Size(936,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([990,90],0)
    {
    Size(0,1080)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([684,90],0)
    {
    Size(0,504)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Plots")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([774,90],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,702,1044]
    Posn = [774,90]
    Icon = [-1,-1]
    Extents = 0,0,702,1044
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,250],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(25473032,"V2a",8388608,,,)
     Curve(23240832,"V2b",32768,,,)
     Curve(23386232,"V2c",128,,,)
     }
    Graph([0,250],[0,0,702,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(22743752,"I2a",8388608,,,)
     Curve(22744304,"I2b",32768,,,)
     Curve(23417784,"I2c",128,,,)
     }
    Graph([0,500],[0,0,702,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(23423416,"I20",8388608,,,)
     }
    PGraph([0,750],[0,0,702,231],"PolyGraph")
     {
     Options = 2
     Curve(22823320,"Br2a",8388608,,,1)
     Curve(23374864,"Br2b",32768,,,1)
     Curve(22825024,"Br2c",128,,,1)
     }
    }
   -Plot-([54,90],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,702,1044]
    Posn = [54,90]
    Icon = [-1,-1]
    Extents = 0,0,702,1044
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,250],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(23588056,"V1a",8388608,,,)
     Curve(23372264,"V1b",32768,,,)
     Curve(23587120,"V1c",128,,,)
     }
    Graph([0,250],[0,0,702,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(23402960,"I1a",8388608,,,)
     Curve(23375424,"I1b",32768,,,)
     Curve(23415536,"I1c",128,,,)
     }
    Graph([0,500],[0,0,702,250],"Current")
     {
     Options = 9
     Units = ""
     Curve(23418872,"I10",8388608,,,)
     }
    PGraph([0,750],[0,0,702,231],"PolyGraph")
     {
     Options = 2
     Curve(23246728,"Br1a",0,,,1)
     Curve(23372824,"Br1b",32768,,,1)
     Curve(23397432,"Br1c",128,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.datalabel([990,486],0,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([810,486],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([594,486],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([396,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([828,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1008,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.datalabel([1026,1044],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1026,1080],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1026,1116],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1152,1044],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1152,1080],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1188,1044],0,22743752,670)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "3.0"
    }
   0.pgb([1188,1080],0,22744304,590)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "3.0"
    }
   0.pgb([1188,954],0,23240832,270)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-500.0"
    Max = "500.0"
    }
   0.datalabel([1314,918],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1314,954],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1314,990],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1350,918],0,23246728,750)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1440,918],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1440,954],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1476,918],0,22823320,740)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1476,990],0,22825024,690)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([1314,1044],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1062,954],0,23372264,250)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400.0"
    Max = "400.0"
    }
   0.pgb([1350,954],0,23372824,730)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1476,954],0,23374864,710)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1062,1080],0,23375424,610)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "2.0"
    }
   0.datalabel([576,972],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([612,972],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([648,972],2,0,-1)
    {
    Name = "I2C"
    }
   0.datalabel([1026,918],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1026,954],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1152,954],2,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([468,972],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([504,972],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([540,972],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([450,360],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   -Wire-([954,360],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   -Wire-([378,900],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([396,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([414,900],0,0,-1)
    {
    Vertex="0,0;0,180"
    }
   -Wire-([414,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([378,864],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.pgb([1188,990],0,23386232,310)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-500.0"
    Max = "500.0"
    }
   -Wire-([1314,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1314,1116],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1314,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1314,1152],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1440,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,1152],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1152,918],2,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([1440,1116],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1440,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,1080],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1440,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,1044],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1440,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,990],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1152,1116],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1152,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1116],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,918],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,954],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1044],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1314,1080],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,990],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1134,990],0,0,300)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,954],0,0,260)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1134,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1134,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1134,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1026,990],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1008,990],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,954],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1008,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1314,1080],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1350,990],0,23397432,700)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datatap([1134,918],0,0,180)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1116,882],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([342,900],0,23401472,110)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   0.datatap([1494,468],6,0,470)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1494,468],2,0,-1)
    {
    Name = "B2"
    }
   0.pgb([1062,1044],0,23402960,680)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "2.0"
    }
   0.pgb([1476,846],0,23403512,140)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datatap([1530,468],6,0,410)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([414,486],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([828,828],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([864,828],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([936,828],2,0,-1)
    {
    Name = "FT4"
    }
   0.datalabel([414,504],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([828,1080],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([810,504],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([990,504],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([936,1080],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1530,468],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1512,540],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([882,990],2,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([594,504],0,0,-1)
    {
    Name = "F2"
    }
   0.breaker3([918,360],0,0,480)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "115.9 [MW]"
    Q = "-18.54 [MVAR]"
    }
   0.pgb([1062,1116],0,23415536,570)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "2.0"
    }
   0.pgb([1188,1116],0,23417784,550)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "3.0"
    }
   -Wire-([1152,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1026,1152],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1026,1152],0,0,-1)
    {
    Name = "I10"
    }
   0.pgb([1062,1152],0,23418872,530)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.4"
    }
   0.datalabel([1152,1152],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1188,1152],0,23423416,510)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.4"
    Max = "0.6"
    }
   0.datatap([828,828],6,0,810)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([864,828],6,0,800)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([900,828],6,0,780)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([936,828],6,0,770)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([900,828],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([810,1062],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datatap([828,1080],0,0,660)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([900,1080],0,0,640)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([936,1080],0,0,630)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([864,1080],0,0,-1)
    {
    Name = "F2"
    }
   0.datatap([864,1080],0,0,650)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([900,1080],0,0,-1)
    {
    Name = "F3"
    }
   0.var_pot([774,954],0,23435208,190)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "4"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([846,954],0,0,210)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([882,954],4,0,390)
    {
    IType = "2"
    OType = "1"
    }
   -Wire-([846,918],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([882,918],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([810,846],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.mux_array([864,882],0,0,760)
    {
    DPath = "0"
    }
   0.mux_array([864,1026],6,0,430)
    {
    DPath = "0"
    }
   0.datalabel([882,954],5,0,-1)
    {
    Name = "FType"
    }
   0.var([1080,432],5,23508032,50)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1134,432],5,23508704,60)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([324,432],3,23509104,40)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   -Sticky-([72,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,396,162,432
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.tpflt([558,468],0,0,840)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1026,468],4,0,820)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.var([810,1152],0,23515944,320)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.datalabel([648,936],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([648,1116],0,0,-1)
    {
    Name = "Fault"
    }
   0.annotation([810,1134],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([1116,882],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([990,882],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1008,918],0,0,150)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([990,882],2,0,-1)
    {
    Name = "V1"
    }
   0.datatap([1008,990],0,0,280)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1008,954],0,0,230)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.tpflt([378,468],0,0,850)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([846,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([900,1152],0,0,-1)
    {
    Name = "Ron"
    }
   0.tpflt([846,468],4,0,830)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.pgb([1350,1044],0,23480288,620)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1476,1044],0,23230232,600)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([1476,1080],0,23231592,560)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.pgb([1350,1080],0,25575552,580)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-30"
    Max = "30"
    }
   0.pgb([1350,1116],0,25577000,540)
    {
    Name = "S1W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1350,1152],0,25578720,500)
    {
    Name = "S1Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1476,1116],0,46662440,520)
    {
    Name = "S2W"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1476,1152],0,46664024,490)
    {
    Name = "S2Q"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.breaker3([486,360],4,0,420)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-114 [MW]"
    Q = "14.55 [MVAR]"
    }
   0.pgb([1350,846],0,39908112,120)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.var([270,432],3,39909608,30)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([306,360],6,0,330)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(freq)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Wire-([576,360],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.var_pot([954,954],2,63439696,220)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "11"
    Value = "1"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   -Wire-([378,864],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   -Wire-([90,1080],0,0,-1)
    {
    Vertex="0,0;0,-180"
    }
   -Wire-([126,900],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Wire-([126,1080],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.select([162,1044],6,0,240)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([396,1044],0,0,-1)
    {
    Vertex="0,0;-198,0"
    }
   0.select([162,864],6,0,380)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.var([54,900],0,39911976,100)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.const([90,864],0,0,90)
    {
    Name = ""
    Value = "10.0"
    }
   0.const([126,1008],1,0,160)
    {
    Name = ""
    Value = "10.0"
    }
   0.var_switch([162,972],1,39914720,130)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([162,792],1,63058752,80)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1512,504],6,0,-1)
    {
    Name = "FType"
    }
   -Wire-([1512,486],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1440,504],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([1440,540],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -TLine-([594,360],0,41328360,-1)
    {
    Name = "LINE1"
    Date = 1144440321
    Freq = "$(freq)"
    Length = "100.0 [km]"
    Dim = 3
    Mode = 1
    Vertex="0,0;18,0;198,0;216,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FrePhase_Options([252,432],0,41310424,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Tower_3_Delta([738,576],0,41143984,-1)
      {
      TName = "3H5"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..\\conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "10 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NG1 = "4"
      NG2 = "5"
      }
     0.Line_Ground([666,666],0,41145624,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.SequenceInfo([558,162],0,41146024,-1)
      {
      Mode = "0"
      X1 = "3.57448095"
      Y1 = "50.7762676"
      X2 = "3.57448095"
      Y2 = "50.7762676"
      X3 = "36.3152201"
      Y3 = "132.647323"
      X4 = "1.0e-005"
      Y4 = "0.000327117946"
      X5 = "0.0"
      Y5 = "0.0"
      X6 = "1.0e-005"
      Y6 = "0.000232266098"
      M1 = "50.9019279149"
      P1 = "85.9732100966"
      M2 = "50.9019279149"
      P2 = "85.9732100966"
      M3 = "137.528569795"
      P3 = "74.6891426178"
      M4 = "0.000327270760373"
      P4 = "88.249012563"
      M5 = "0.0"
      P5 = "0.0"
      M6 = "0.000232481268665"
      P6 = "87.5347062197"
      }
     }
    }
   -Wire-([558,360],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([846,360],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   -Sticky-([1152,396],0)
    {
    Name = ""
    Font = 1
    Bounds = 1152,396,1242,432
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   0.source3R([1098,360],2,0,340)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(freq)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   .Plots([1404,432],0,0,70)
    {
    }
   -Sticky-([36,36],0)
    {
    Name = ""
    Font = 1
    Bounds = 36,36,522,216
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Case Description: 
- Two Thevinen Impedance sources connected via one 100km transmission line.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via one transmission line.
- Four fault positions for full fault control ahead and behind station relays.
- Two breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible.

Global Substitution  \"freq =  60.0 [Hz]\"  is  used in this  example."
    }
   .Controls([1404,522],0,0,400)
    {
    }
   0.datalabel([648,720],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([612,720],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([576,720],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([360,684],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([360,756],2,0,-1)
    {
    Name = "V1A"
    }
   -Wire-([504,720],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([360,720],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([360,720],2,0,-1)
    {
    Name = "V1B"
    }
   0.currenttf([576,756],1,0,460)
    {
    Np = "1"
    Ns = "400"
    SecR = "0.5 [ohm]"
    SecL = "0.8e-3 [H]"
    Area = "6.5e-3 [m*m]"
    PathL = "0.5 [m]"
    Freq = "60.0 [Hz]"
    Bremn = "0.0 [T]"
    Curr0 = "0.0 [A]"
    mat = "1"
    Bknee = "1.0 [T]"
    CnstB1 = "0.0035"
    CnstB2 = "0.00117"
    CnstB3 = "3.6e-8"
    IndxB2 = "9"
    IndxB3 = "35"
    CnstE1 = "0.1"
    CnstH2 = "0.1"
    CnstH3 = "0.11"
    CnstH4 = "3.0e-5"
    BurR = "0.5 [ohm]"
    BurL = "0.8e-3 [H]"
    Iidel = ""
    Itotl = ""
    Imagn = ""
    Bout = ""
    }
   0.currenttf([612,756],1,0,450)
    {
    Np = "1"
    Ns = "400"
    SecR = "0.5 [ohm]"
    SecL = "0.8e-3 [H]"
    Area = "6.5e-3 [m*m]"
    PathL = "0.5 [m]"
    Freq = "60.0 [Hz]"
    Bremn = "0.0 [T]"
    Curr0 = "0.0 [A]"
    mat = "1"
    Bknee = "1.0 [T]"
    CnstB1 = "0.0035"
    CnstB2 = "0.00117"
    CnstB3 = "3.6e-8"
    IndxB2 = "9"
    IndxB3 = "35"
    CnstE1 = "0.1"
    CnstH2 = "0.1"
    CnstH3 = "0.11"
    CnstH4 = "3.0e-5"
    BurR = "0.5 [ohm]"
    BurL = "0.8e-3 [H]"
    Iidel = ""
    Itotl = ""
    Imagn = ""
    Bout = ""
    }
   -Sticky-([972,828],0)
    {
    Name = ""
    Font = 1
    Bounds = 972,828,1098,864
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.currenttf([648,756],1,0,440)
    {
    Np = "1"
    Ns = "400"
    SecR = "0.5 [ohm]"
    SecL = "0.8e-3 [H]"
    Area = "6.5e-3 [m*m]"
    PathL = "0.5 [m]"
    Freq = "60.0 [Hz]"
    Bremn = "0.0 [T]"
    Curr0 = "0.0 [A]"
    mat = "1"
    Bknee = "1.0 [T]"
    CnstB1 = "0.0035"
    CnstB2 = "0.00117"
    CnstB3 = "3.6e-8"
    IndxB2 = "9"
    IndxB3 = "35"
    CnstE1 = "0.1"
    CnstH2 = "0.1"
    CnstH3 = "0.11"
    CnstH4 = "3.0e-5"
    BurR = "0.5 [ohm]"
    BurL = "0.8e-3 [H]"
    Iidel = ""
    Itotl = ""
    Imagn = ""
    Bout = ""
    }
   0.pgb([1062,990],0,23587120,290)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400.0"
    Max = "400.0"
    }
   0.pgb([1062,918],0,23588056,170)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-400.0"
    Max = "400.0"
    }
   0.pgb([1188,918],0,25473032,200)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-500.0"
    Max = "500.0"
    }
   0.ccvt1([396,684],0,0,350)
    {
    C1P = "2920.0 [pF]"
    C2P = "131394.0 [pF]"
    LCP = "50.0 [H]"
    VTrat = "43.48"
    Lp = "0.47e-3 [H]"
    Rp = "0.05 [ohm]"
    Ls = "0.47e-3 [H]"
    Rs = "0.18 [ohm]"
    Leddy = "2.5 [W]"
    Vop = "115 [V]"
    Bop = "0.8 [T]"
    ClosH = "5.0 [W]"
    Remn = "0.0 [pu]"
    Indx2 = "8"
    Indx3 = "32"
    Cnst1 = "0.6"
    Cnst2 = "0.03"
    Cnst3 = "1.0e-7"
    BurRs = "301.0 [ohm]"
    BurLs = "2.4 [H]"
    BurRp = "785.0 [ohm]"
    Lfer1 = "0.01 [H]"
    Rfer1 = "5.5 [ohm]"
    Cfer1 = "8.0e-6 [F]"
    Lfer2 = "0.394 [H]"
    Rfer2 = "3.9 [ohm]"
    Rfer3 = "40.0 [ohm]"
    Bout = ""
    Itotl = ""
    Imagn = ""
    }
   0.ccvt1([396,756],0,0,370)
    {
    C1P = "2920.0 [pF]"
    C2P = "131394.0 [pF]"
    LCP = "50.0 [H]"
    VTrat = "43.48"
    Lp = "0.47e-3 [H]"
    Rp = "0.05 [ohm]"
    Ls = "0.47e-3 [H]"
    Rs = "0.18 [ohm]"
    Leddy = "2.5 [W]"
    Vop = "115 [V]"
    Bop = "0.8 [T]"
    ClosH = "5.0 [W]"
    Remn = "0.0 [pu]"
    Indx2 = "8"
    Indx3 = "32"
    Cnst1 = "0.6"
    Cnst2 = "0.03"
    Cnst3 = "1.0e-7"
    BurRs = "301.0 [ohm]"
    BurLs = "2.4 [H]"
    BurRp = "785.0 [ohm]"
    Lfer1 = "0.01 [H]"
    Rfer1 = "5.5 [ohm]"
    Cfer1 = "8.0e-6 [F]"
    Lfer2 = "0.394 [H]"
    Rfer2 = "3.9 [ohm]"
    Rfer3 = "40.0 [ohm]"
    Bout = ""
    Itotl = ""
    Imagn = ""
    }
   0.recorder2_0([540,1044],0,0,720)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".4"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".4"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".4"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   -Sticky-([792,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 792,612,1386,774
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
CCVT and CT models have been added to voltages and currents  at Location Bus 1

CCVT  overall ratio is a combination of C1/C2 ratio and  VT ratio. 
Remember that CCVT  have a frequency dependency and require tuning based 
Fundamental frequency.   In this case set to CVT ratio 2000:1  ; CT Ratio 400:1 

Remember to change RTP Recorder channels to reflect 
the input signals to the recorder as secondary signals and not primary. 
Note:  Recorder also stores secondary signals. 
Ratios  inside the recorder  serve only to allow user to recalculate primary values. "
    }
   0.recorder2_0([540,864],0,0,790)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "1"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2000"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "1"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2000"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "1"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2000"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "1"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "400"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "1"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "400"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "1"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.ccvt1([468,720],0,0,360)
    {
    C1P = "2920.0 [pF]"
    C2P = "131394.0 [pF]"
    LCP = "50.0 [H]"
    VTrat = "43.48"
    Lp = "0.47e-3 [H]"
    Rp = "0.05 [ohm]"
    Ls = "0.47e-3 [H]"
    Rs = "0.18 [ohm]"
    Leddy = "2.5 [W]"
    Vop = "115 [V]"
    Bop = "0.8 [T]"
    ClosH = "5.0 [W]"
    Remn = "0.0 [pu]"
    Indx2 = "8"
    Indx3 = "32"
    Cnst1 = "0.6"
    Cnst2 = "0.03"
    Cnst3 = "1.0e-7"
    BurRs = "301.0 [ohm]"
    BurLs = "2.4 [H]"
    BurRp = "785.0 [ohm]"
    Lfer1 = "0.01 [H]"
    Rfer1 = "5.5 [ohm]"
    Cfer1 = "8.0e-6 [F]"
    Lfer2 = "0.394 [H]"
    Rfer2 = "3.9 [ohm]"
    Rfer3 = "40.0 [ohm]"
    Bout = ""
    Itotl = ""
    Imagn = ""
    }
   -Wire-([432,756],0,0,-1)
    {
    Vertex="0,0;36,0;36,36"
    }
   -Wire-([432,684],0,0,-1)
    {
    Vertex="0,0;108,0;108,108"
    }
   -Divider-([54,594],0)
    {
    Size(1476,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([540,360],0,0,10)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([864,360],4,0,20)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1314,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1314,846],2,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1440,846],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,846],2,0,-1)
    {
    Name = "V2rms"
    }
   }
  }
 }

